;*********************************************************************
;*
;*              User Memory Programmer Interface Parameters
;*
;*********************************************************************
;* FileName:        memrtnes.inc
;* Dependencies:    
;* Processor:       PIC18C601/801
;* Complier:        MPLAB 5.11.00
;* Company:         Microchip Technology, Inc.
;*
;* Software License Agreement
;*
;* The software supplied herewith by Microchip Technology Incorporated
;* (the Company) for its PICmicro Microcontroller is intended and
;* supplied to you, the Companys customer, for use solely and
;* exclusively on Microchip PICmicro Microcontroller products. The
;* software is owned by the Company and/or its supplier, and is
;* protected under applicable copyright laws. All rights are reserved.
;* Any use in violation of the foregoing restrictions may subject the
;* user to criminal sanctions under applicable laws, as well as to
;* civil liability for the breach of the terms and conditions of this
;* license.
;*
;* THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;*
;*
;*
;* NOTE:
;*		This file provides uniform API for PICDEM-18R monitor program
;*		and ICD-R debugger.
;*		These API allow any user-supplied memory routines to use
;*		with PICDEM-18R monitor program and ICD-R debugger.
;*
;*
;* Author               Date        Comment
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;* Nilesh Rajbharti     3/27/01      Original (Rev. 1.0)
;********************************************************************/


; There are two routines for each attachable memory.
; User must supply Write and Erase routines.

; WREG Write(DWORD Address, BYTE Byte, BYTE Flags)


; Flags applies to Write routine only and specifies whether current
; Write operation is first in a series, last or intermediate.
; Following are the legal values as supplied by PICDEM-18R Monitor
; and ICD-R debugger.
;
;	Value		Meaning
;	----------------------------------------------------------------
;	00h			First byte being written
;	01h			Last byte being written
;	02h			Only byte being written.
;	All others	Intermediate byte being written
;
; User may use Flags information to switch to program or read mode
; of attached memory.


; These are the paramters location as passed by monitor and ICD-R

; 32-bit address to be read or written.  Since 801 can only reach
; 2MB, upper byte is not used.
Address			EQU		.0

; All programming and reading is done byte at a time.
Byte			EQU		.4


; Flag format.
BYTE_FLAG_BIT0	EQU	0		; D0
BYTE_FLAG_BIT1	EQU	1		; D1
BW_TYPE_BIT	EQU	2		; D2
MCU_TYPE_BIT	EQU	3		; D3

Flags			EQU		.6


